#open "crayon";;
let flottant = function
  | Entier i -> float_of_int i  | Flottant f -> f;;
  
let ajoute_nombres = function
  | (Entier i, Entier j) -> Entier (i + j)
  | (n1, n2) -> Flottant (flottant n1 +. flottant n2)
and soustrais_nombres = function
  | (Entier i, Entier j) -> Entier (i - j)
  | (n1, n2) -> Flottant (flottant n1 -. flottant n2)and multiplie_nombres = function
  | (Entier i, Entier j) -> Entier (i * j)
  | (n1, n2) -> Flottant (flottant n1 *. flottant n2)
and divise_nombres = function
  | (Entier i, Entier j) -> Entier (i / j)
  | (n1, n2) -> Flottant (flottant n1 /. flottant n2)and compare_nombres = function
  | (Entier i, Entier j) -> i >= j  | (n1, n2) -> (flottant n1 >=. flottant n2);;

let rec valeur_expr env = function
  | Constante n -> n
  | Somme (e1, e2) ->
     ajoute_nombres (valeur_expr env e1, valeur_expr env e2)
  | Produit (e1, e2) ->
     multiplie_nombres (valeur_expr env e1, valeur_expr env e2)
  | Diffrence (e1, e2) ->
     soustrais_nombres (valeur_expr env e1, valeur_expr env e2)
  | Quotient (e1, e2) ->
     divise_nombres (valeur_expr env e1, valeur_expr env e2)
  | Variable s -> assoc s env;;

let procdures_dfinies = ref ([] : (string * procdure) list);;

let dfinit_procdure (nom, proc as liaison) =
  procdures_dfinies := liaison :: !procdures_dfinies
and dfinition_de nom_de_procdure =
  try
    assoc nom_de_procdure !procdures_dfinies
  with Not_found ->
    failwith ("procdure inconnue: " ^ nom_de_procdure);;
      
let valeur_entire = function
  | Entier i -> i
  | Flottant f -> failwith "entier attendu";;

exception Fin_de_procdure;;

let rec excute_ordre env = function
  | Av e -> avance (flottant (valeur_expr env e))
  | Re e -> avance (-. (flottant (valeur_expr env e)))
  | Tg a -> tourne (flottant (valeur_expr env a))
  | Td a -> tourne (-. (flottant (valeur_expr env a)))
  | Lc -> fixe_crayon true
  | Bc -> fixe_crayon false
  | Ve -> vide_cran()
  | Rep (n, l) ->
     for i = 1 to valeur_entire (valeur_expr env n) do
       do_list (excute_ordre env) l
     done
  | Si (e1, e2, alors, sinon) ->
      if compare_nombres (valeur_expr env e1, valeur_expr env e2)
      then do_list (excute_ordre env) alors
      else do_list (excute_ordre env) sinon
  | Stop -> raise Fin_de_procdure
  | Excute (nom_de_procdure, args) ->
     let dfinition = dfinition_de nom_de_procdure in
     let variables = dfinition.Paramtres
     and corps = dfinition.Corps in
     let rec augmente_env = function
       | [],[] -> env
       | variable::vars, expr::exprs ->
          (variable, valeur_expr env expr) :: augmente_env (vars, exprs)
       | _ -> failwith ("mauvais nombre d'arguments pour "
                    ^ nom_de_procdure) in     let env_pour_corps = augmente_env (variables, args) in
     try
       do_list (excute_ordre env_pour_corps) corps
     with Fin_de_procdure -> ();;

let rec excute_phrase = function
  | Ordre ord -> excute_ordre [] ord
  | Pour (nom, proc as liaison) -> dfinit_procdure liaison
and excute_programme = function
  | Programme phs -> do_list excute_phrase phs;;
